from Types import Insegnamento, DB
import pylightxl.pylightxl as xl
import logging
from typing import List, Dict, Set
import sqlite3



class QueryReader:
    def __init__(self, filename):
        self.db = xl.readxl(fn=filename)
        self.sheetQuery = self.db.ws(ws="query")
        self.listInsegnamenti:List[Insegnamento] = list()
        self.listInsegnamentiNoDup = list()
        self.listInsegnamentiDup = list()
        self.db = sqlite3.connect(DB)
        self.listInsegnamentiUntouched:List[Insegnamento] = list()
    
    def debug(self, dup=False, codInc = ''):
        print()
        print('*'*60)
        if codInc != '':
            for ins in self.listInsegnamenti:
                if ins.ID_INC == codInc:
                    print(ins)
                    print()
        elif dup:
            for ins in self.listInsegnamenti:
                print(ins)
                print()
        else:
            for ins in self.listInsegnamentiNoDup:
                print(ins)
                print()
        print('*'*60)
    
    def debugNano(self):
        for ins in self.listInsegnamenti:
            if ins.nome_cdl == "NANOTECHNOLOGIES FOR ICTs (NANOTECNOLOGIE PER LE ICT)":
                print(ins.titolo, ins.ID_INC)
                print(ins.docenti)
                print()
    
    def filterNano(self):
        newList = list()
        for ins in self.listInsegnamenti:
            if ins.nome_cdl in ["NANOTECHNOLOGIES FOR ICTs (NANOTECNOLOGIE PER LE ICT)"]:
                newList.append(ins)
        self.listInsegnamenti = newList
 
    def filter_PD_1(self):
        """solo primo periodo didattico"""
        newList = list() 
        for ins in self.listInsegnamenti:
            if ins.pd in ["1-1","1-2"]:
                newList.append(ins)
        self.listInsegnamenti = newList
        
    def filter_primoAnnoTriennale(self):
        '''Ignoro primo anno Laurea Triennale'''
        newList = list()
        for ins in self.listInsegnamenti:
            if ins.tipo_laurea == "1" and ins.anno == "1":
                continue
            newList.append(ins)
        self.listInsegnamenti = newList

    def readQuery(self):
        lineHeader = True
        for row in self.sheetQuery.rows:
            if lineHeader:
                lineHeader = False
                continue
            ins:Insegnamento = Insegnamento(row)
            # istruzioni mail Aldo - 21/6 22:20
            if ins.ID_INC in [260788, 260789, 259802, 261402, 263325, 259725, 260075, 261455, 260425]:
                print("Skipped import of: " + str(ins.ID_INC))
            else:
                self.listInsegnamenti.append(ins)
        self.listInsegnamentiUntouched = self.listInsegnamenti.copy()
        
    def countDistinctID_INC(self) -> int:
        setIdInc = set()
        for ins in self.listInsegnamentiUntouched:
            setIdInc.add(ins.ID_INC)
        return len(setIdInc)
    
    def print_ID_INC_duplicates(self):
        if len(self.listInsegnamentiDup) == 0:
            return
        print("*"*60)
        print("ID_INC duplicati")
        for ins in self.listInsegnamentiDup:
            print(ins)
            print()
        print("*"*60)
     
    def createCodInsUnique(self) -> Dict[int,Set[str]]:
        '''Per caricare list codIns degli Insegnamenti'''
        resDict:Dict[int,Set[str]] = dict()
        for ins in self.listInsegnamenti:
            if ins.ID_INC not in resDict.keys():
                resDict[ins.ID_INC] = set()
            resDict[ins.ID_INC].add(ins.cod_ins[0])
        return resDict            
    
    def createOrientamentiUnique(self) -> Dict[str,Insegnamento]:
        '''Per caricare la lista di Orientamenti senza duplicati [ID_INC_Cdl_Orientamento]'''
        res:Dict[str,Insegnamento] = dict()
        for ins in self.listInsegnamenti:
            if len(ins.orientamento[0].split('(')) > 1:
                orient = ins.orientamento[0].split('(')[0].strip()
            else:
                orient = ins.orientamento[0]      
            s = str(ins.ID_INC) + "_" + ins.nome_cdl[0] + "_" + orient
            res[s] = ins
        return res
        
    def split_ID_INC_duplicates(self):
        '''Tengo un solo Insegnamento per ogni ID_INC, tengo tutte le copie in self.listInsegnamentiDup'''
        ID_INCs_src = map(lambda ins: ins.ID_INC, self.listInsegnamenti)
        ID_INCs_set = set(ID_INCs_src)
        ID_INCs_src = map(lambda ins: ins.ID_INC, self.listInsegnamenti)
        ID_INCs_list = list(ID_INCs_src)
        setIDIncDup = set()
                
        for idInc in ID_INCs_set:
            if ID_INCs_list.count(idInc) > 1:
                setIDIncDup.add(idInc)
            self.listInsegnamentiNoDup.append(list(filter(lambda ins: ins.ID_INC == idInc, self.listInsegnamenti))[0])

        if len(setIDIncDup) != 0:
            logging.warning("queryReader.split_ID_INC_duplicates(): found ID_INC duplicates on the query file") 
            listIDIncDup = list(setIDIncDup)
            for idInc in listIDIncDup:
                for i in range(len(self.listInsegnamenti)):
                    if idInc == self.listInsegnamenti[i].ID_INC:
                        self.listInsegnamentiDup.append(self.listInsegnamenti[i])
    
    def fixAutoIns_beforeSplit(self):
        """Merge di varie entry con lo stesso ID_INC, stessa lista docenti, stesso titolo e stessi cfu"""
        setIdInc = set(map(lambda ins: ins.ID_INC, self.listInsegnamenti))
        
        for idInc in setIdInc:
            # if idInc not in ["252068", "251776", "251667", "251668", "255169", "252204"]:
                # continue
            
            setCdl = set()
            setPerc = set()
            setCodIns = set()
            firstCfu = 0
            firstDoc = ['']
            firstTitolo = ''
            skip = False
        
            for ins in self.listInsegnamenti:
                if ins.ID_INC == idInc and (firstCfu == 0 or ins.cfu == firstCfu) and (firstDoc == [''] or firstDoc == ins.docenti): # and (firstTitolo == '' or firstTitolo == ins.titolo):
                    if firstCfu == 0:
                        firstCfu = ins.cfu
                    if firstDoc == ['']:
                        firstDoc = ins.docenti
                    if firstTitolo == '':
                        firstTitolo = ins.titolo
                    
                    for cdl in ins.nome_cdl:
                        setCdl.add(cdl)
                    for orient in ins.orientamento:                      
                        setPerc.add(orient)
                    for codIns in ins.cod_ins:
                        setCodIns.add(codIns)
                elif ins.ID_INC == idInc and ( not(firstCfu == 0 or ins.cfu == firstCfu) or not(firstDoc == [''] or firstDoc == ins.docenti)): # or not(firstTitolo == '' or firstTitolo == ins.titolo)):
                    skip = True
            
            if skip:
                continue
            
            if len(setCdl) > 1 or len(setPerc) > 1:
                # get first
                base = list(filter(lambda ins: ins.ID_INC == idInc, self.listInsegnamenti))[0]
                base.orientamento = list(setPerc)
                base.nome_cdl = list(setCdl)
                base.cod_ins = list(setCodIns)
                # remove all
                self.listInsegnamenti = list(filter(lambda ins: not (ins.ID_INC == idInc), self.listInsegnamenti))
                self.listInsegnamenti.append(base)
                        
    def fixManualIns_beforeSplit(self):        
        # remove 251776 titolo: Materials and characterizations for Micro and Nanotechnologies da 6 cfu
        self.listInsegnamenti = list(filter(lambda ins: not (ins.ID_INC == "251776" and ins.cfu == 6), self.listInsegnamenti))
                                
        #merge ID_INC: 252204 titolo: Physics of technological processes/Design of microsystems (modulo Design of microsystems)
        # ins in 2 moduli
        insExtr = list(filter(lambda ins: ins.ID_INC == "252204", self.listInsegnamenti))[0]
        insExtr.titolo = "Physics of technological processes/Design of microsystems (entrambi i moduli)"
        self.listInsegnamenti = list(filter(lambda ins: not (ins.ID_INC == "252204"), self.listInsegnamenti))
        self.listInsegnamenti.append(insExtr)
        
                    
    def fixManualIns_afterSplit(self):
        pass

    def db_insertBeforeMixing(self, delete=True):
        self.db_insertCdl(delete=delete)
        self.db_insertOrientamenti(delete=delete)
        self.db_insertDocenti(delete=delete)        
    
    def db_insertCdl(self, delete=False):
        '''1 - before mixing'''
        if delete:
            sql = '''DELETE FROM Corso_di_laurea'''
            cur = self.db.cursor()
            cur.execute(sql)
            self.db.commit()
        
        setCdl = set()
        for ins in self.listInsegnamenti:
            setCdl.add(str(ins.tipo_laurea) + ';' + str(ins.nome_cdl[0]))
                    
        cur = self.db.cursor()
        sql = '''INSERT INTO Corso_di_laurea(tipoCdl, nomeCdl) VALUES(?,?)'''
        for cdl in setCdl:
            cur.execute(sql, (cdl.split(';')[0], cdl.split(';')[1]))
        self.db.commit()
    
    def db_insertOrientamenti(self, delete=False):
        '''2 - before mixing'''
        if delete:
            sql = '''DELETE FROM Orientamento'''
            cur = self.db.cursor()
            cur.execute(sql)
            self.db.commit()
            
        setOrientamenti = set()
        for ins in self.listInsegnamenti:
            orientExt = ins.orientamento[0].split('(')[0].strip()
            setOrientamenti.add(orientExt + ";" + str(ins.nome_cdl[0]) + ";" + str(ins.tipo_laurea))
        
        cur = self.db.cursor()
        sql = '''INSERT INTO Orientamento(orientamento, nomeCdl, tipoCdl) VALUES(?,?,?)'''
        for orient in setOrientamenti:
            cur.execute(sql, orient.split(';'))
        self.db.commit()
    
    def db_insertDocenti(self, delete=False):
        '''3 - before mixing'''
        if delete:
            sql = '''DELETE FROM Docente'''
            cur = self.db.cursor()
            cur.execute(sql)
            self.db.commit()
        
        setDocenti = set()
        for ins in self.listInsegnamenti:
            for doc in ins.docenti:
                setDocenti.add(doc)
        
        cur = self.db.cursor()
        sql = '''INSERT INTO Docente(Cognome) VALUES(?)'''
        for doc in setDocenti:
            cur.execute(sql, [doc])
        self.db.commit()

        
        